/* ********************************************************************
  ıV7 ƷתרҵʽSQL

  By Sam on 2009-01-07
**********************************************************************/

SELECT GoodsNO = i.item_no,
       Barcode = i.item_subno,
       GoodsName = i.item_name,
       CategoryNO = i.item_clsno,
       BrandNO = i.item_brand,
       Brand = convert(varchar(40), ''),
       Unit = isnull(unit_no, ''),
       Spec = isnull(i.item_size, ''),
       Home = isnull(i.product_area, ''),

       BuyPrice = i.price,
       SalePrice = i.sale_price,
       StockQty = convert(numeric(12,3), null),
       VipPrice = i.vip_price,

       Memo1 = isnull(i.other1, ''),
       Memo2 = isnull(i.other2, ''),
       VendorNO = i.sup_no,
       BuyTaxRate = isnull(i.in_rate, 0) * 100,
       SaleTaxRate = isnull(i.sale_rate, 0) * 100,
       CategoryName = convert(varchar(40), ''),
       VendorName = convert(varchar(60), ''),
       CaseUnits = 1,

       i.barcode_no1,
       i.barcode_no2,
       i.barcode_no3,
       i.barcode_no4
  into #a
  FROM bi_t_item_info i

update #a set VendorName = sup_name
  from bi_t_supcust_info v where VendorNO = v.supcust_no

update #a set CategoryName = item_clsname
  from bi_t_item_cls v where CategoryNO = v.item_clsno and v.item_clsno <> 'QS' and item_flag = 0

update #a set Brand = item_clsname
  from bi_t_item_cls v where BrandNO = v.item_clsno and v.item_clsno <> 'QS' and item_flag = 1

update #a set StockQty = v_stock_total
  from pos_v_stock_total v where GoodsNO = v.v_item_no

create table #Barcode (sGoodsNO varchar(20), sBarcode varchar(20))

insert into #Barcode select GoodsNO, barcode_no1 from #a where isnull(barcode_no1, '') <> ''
insert into #Barcode select GoodsNO, barcode_no2 from #a where isnull(barcode_no2, '') <> ''
insert into #Barcode select GoodsNO, barcode_no3 from #a where isnull(barcode_no3, '') <> ''
insert into #Barcode select GoodsNO, barcode_no4 from #a where isnull(barcode_no4, '') <> ''

select
     = CategoryName,
    Ʒ = GoodsName,
     = isnull(Spec, ''),
    λ = isnull(Unit, ''),
     = Barcode,
     = BuyPrice,
    ۼ = SalePrice,
    Աۼ = VipPrice,
     = StockQty,
    Ӧ = isnull(VendorName, ''),
    ˰ = BuyTaxRate,
    ˰ = SaleTaxRate,
    װλ = CaseUnits,
     = isnull(Home, ''),
    Ʒ = isnull(Brand, ''),
    ע1 = Memo1,
    ע2 = Memo2,
    Ʒ = GoodsNO into #c
  from #a
union
select
     = CategoryName,
    Ʒ = GoodsName,
     = isnull(Spec, ''),
    λ = isnull(Unit, ''),
     = b.sBarcode,
     = BuyPrice,
    ۼ = SalePrice,
    Աۼ = VipPrice,
     = 0,
    Ӧ = isnull(VendorName, ''),
    ˰ = BuyTaxRate,
    ˰ = SaleTaxRate,
    װλ = CaseUnits,
     = isnull(Home, ''),
    Ʒ = isnull(Brand, ''),
    ע1 = Memo1,
    ע2 = Memo2,
    Ʒ = a.GoodsNO
  from #a a, #Barcode b
  where a.GoodsNO = b.sGoodsNO

select * from #c order by Ʒ, abs() desc

drop table #a, #Barcode, #c

